(function ($) {
    const BW8_CONFIG = {host: "https://www.bangwo8.com", imBase: "/osp2016/im"};
    var browser = {
        versions: function () {
            var u = navigator.userAgent, app = navigator.appVersion;
            return {
                trident: u.indexOf("Trident") > -1,
                presto: u.indexOf("Presto") > -1,
                webKit: u.indexOf("AppleWebKit") > -1,
                gecko: u.indexOf("Gecko") > -1 && u.indexOf("KHTML") == -1,
                mobile: !!u.match(/AppleWebKit.*Mobile.*/),
                ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),
                android: u.indexOf("Android") > -1 || u.indexOf("Linux") > -1,
                iPhone: u.indexOf("iPhone") > -1,
                iPad: u.indexOf("iPad") > -1,
                webApp: u.indexOf("Safari") == -1,
                weixin: u.indexOf("MicroMessenger") > -1,
                qq: u.match(/\sQQ/i) == " qq"
            }
        }(), language: (navigator.browserLanguage || navigator.language).toLowerCase()
    };
    var bw8ThirdParty = {
        bw8ThirdData: {
            field_key: "",
            field_value: "",
            tagSkillList: "",
            permissions: 0,
            vendorID: 47482,
            directLink: 1,
            login: 1
        }, checkTagData: function () {
            try {
                var thirdPartyTag = $("#bw8-third-party");
                if (thirdPartyTag.length) {
                    var bw8ThirdPartyData = thirdPartyTag.data("thirdparty") || {};
                    $.extend(this.bw8ThirdData, bw8ThirdPartyData);
                    return true
                } else {
                    console.log("[error] bw8 third party tag is missing!");
                    return false
                }
            } catch (err) {
                console.log("[error] unexpected error:" + err)
            }
            return false
        }, checkUserLogin: function () {
            return this.bw8ThirdData.login ? 1 : 0
        }, calcWindowSize: function () {
            var baseSize = {
                url: "/index.php?vendorID=" + this.bw8ThirdData.vendorID + "&directLink=1&field_key=authAccount",
                width: 900,
                height: 600,
                name: "bw8",
                options: ",location=0,menubar=0,scrollbars=0,status=0,toolbar=0,resizable=0",
            };
            var dirName = browser.versions.mobile ? "/h5" : "/pc";
            baseSize.url = BW8_CONFIG.host + BW8_CONFIG.imBase + dirName + baseSize.url;
            var screenWidth = screen.width;
            var screenHeight = screen.height;
            if (screenWidth < 1366) {
                baseSize.width = 800;
                baseSize.height = 600
            }
            baseSize.left = (screenWidth - baseSize.width) / 2;
            baseSize.top = (screenHeight - baseSize.height) / 2;
            return baseSize
        }, bw8OpenWindow: function (iframe) {
            if (browser.versions.mobile) {
                window.location.href = iframe.url
            } else {
                var newWin = window.open(iframe.url, iframe.name, "left=" + iframe.left + ",top=" + iframe.top + ",width=" + iframe.width + ",height=" + iframe.height + "," + iframe.options);
                newWin.focus();
                return newWin
            }
        }, init: function () {
            var ex = this;
            var checkRes = ex.checkTagData();
            var iframeObj;
            if (checkRes) {
                iframeObj = ex.calcWindowSize();
                iframeObj.url += "&customInfo=" + ex.bw8ThirdData.customInfo + "&field_value=" + ex.bw8ThirdData.field_value + "&tagSkillList=" + ex.bw8ThirdData.tagSkillList + "&permissions=" + ex.bw8ThirdData.permissions
            }
            $("#bw8-third-party").unbind().bind("click", function () {
                ex.bw8OpenWindow(iframeObj);
                // if (ex.checkUserLogin()) {
                //     ex.bw8OpenWindow(iframeObj)
                // } else {
                //     alert("尊敬的用户，您好，登录后才可以和我聊天哦！");
                //     return false
                // }
            })
        }
    };
    bw8ThirdParty.init()
})(typeof Zepto !== "undefined" ? Zepto : jQuery);